#include "blocks/elephant.h"
Block* player2_allocate(void) {
    Elephant * self;
    land_alloc(self);
    return & self->super;
}
void player2_init(Block * super) {
    Elephant * self = (void *) super;
    self->step = 0;
    self->direction = 0;
    game->elephant = & self->super;
}
void player2_tick(Block * super) {
    Elephant * self = (void *) super;
    float tx = game->target_x;
    float tz = game->target_z;
    float dx = tx - super->x;
    float dz = tz - super->z;
    float d = sqrt(dx * dx + dz * dz);
    if (d > 1) {
        float run = 1;
        if (super->run) {
            run = 2;
        }
        super->dx += dx / d * run;
        super->dz += dz / d * run;
        self->step += 1;
        self->step &= 31;
        float a = (atan2(dx, dz) + pi * 1.75) / (pi * 2);
        self->direction = ((int) round(a * 8)) % 8;
    }
    else {
        super->run = 0;
    }
    int f = (self->step / 4) % 8;
    if (f >= 5) {
        f = 8 - f;
    }
    int dir = (self->direction + 7) % 8;
    if (dir >= 3) {
        super->flipped = 0;
        dir -= 3;
    }
    else {
        super->flipped = 1;
        dir = 3 - dir;
    }
    super->frame = dir * 5 + f;
    block_tick(super);
    dialog_elephant(super);
}
bool player2_touch(Block * super, Block * c, float dx, float dy, float dz) {
    // can step on planks
    //print("%s %.1f %.1f %.1f", c.block_type.name, super.y, c.y, c.ys)
    if (c->ys < 12 && super->y + 12 > c->y + c->ys && super->y < c->y + 1) {
        super->y += 12;
    }
    return 1;
}
